
{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK CheckXbotPos (*Rising edge triggered wrapper of the ReadXbotPox command*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (1-78)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Valid : {REDUND_UNREPLICABLE} BOOL; (* xbot position is up-to-date, if false the output position is the last known position *)
		PosX : {REDUND_UNREPLICABLE} REAL; (* xbot X position in meters*)
		PosY : {REDUND_UNREPLICABLE} REAL; (* xbot Y position in meters*)
		PosZ : {REDUND_UNREPLICABLE} REAL; (* xbot Z position in meters*)
		PosRx : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about X axis in radians *)
		PosRy : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about Y axis in radians*)
		PosRz : {REDUND_UNREPLICABLE} REAL; (* xbot rotation about Z axis in radians*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		ReadXbotPos : {REDUND_UNREPLICABLE} PMC_ReadXbotPos;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK CheckXbotState (*Rising edge triggered wrapper of the ReadXbotState command*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (* Execution of the function block begins on a rising edge of this input.*)
		XbotID : {REDUND_UNREPLICABLE} USINT; (* xbot ID# (1-78)*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (* Execution successful. Function block is finished*)
		Valid : {REDUND_UNREPLICABLE} BOOL; (* successfully read xbot state*)
		State : {REDUND_UNREPLICABLE} USINT; (* 0 = undetected, 1 = discovering, 2 = landed, 3 = idle, 4 = disabled, 5 = in motion, 6 = waiting, 7 = stopping, 8 = obstacle, 9 = hold, 10 = stopped, 14 = error*)
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		ReadXbotState : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Delay (*Delays rising edge propagation for a certain number of function block calls*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL; (*Rising edge input*)
		Cycles : {REDUND_UNREPLICABLE} UDINT; (*number of calls to delay for*)
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL; (*Ouput*)
	END_VAR
	VAR
		CyclesSinceRising : {REDUND_UNREPLICABLE} UDINT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example01_longaxismotion (*2x1 flyways w/ 1 xbots - linear, arc target, block buffer, release buffer, clear macro, save macro, run macro*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ArcMotionTarget1 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ArcMotionTarget2 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_MotionBufferCtrl1 : {REDUND_UNREPLICABLE} PMC_MotionBufferCtrl;
		PMC_ArcMotionTarget3 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ArcMotionTarget4 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion5 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_MotionBufferCtrl2 : {REDUND_UNREPLICABLE} PMC_MotionBufferCtrl;
		PMC_ClearMacro1 : {REDUND_UNREPLICABLE} PMC_ClearMacro;
		PMC_ArcMotionTarget5 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion6 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ArcMotionTarget6 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion7 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_SaveMacro1 : {REDUND_UNREPLICABLE} PMC_SaveMacro;
		PMC_RunMacro1 : {REDUND_UNREPLICABLE} PMC_RunMacro;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example02_shortaxismotion (*2x1 flyways w/ 1 xbots - short axis, 6 dof, 6 dof w speed*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ShortAxisMotion1 : {REDUND_UNREPLICABLE} PMC_ShortAxisMotion;
		PMC_ShortAxisMotion2 : {REDUND_UNREPLICABLE} PMC_ShortAxisMotion;
		PMC_ShortAxisMotion3 : {REDUND_UNREPLICABLE} PMC_ShortAxisMotion;
		PMC_6DMotion1 : {REDUND_UNREPLICABLE} PMC_6DMotion;
		Pos_array : {REDUND_UNREPLICABLE} ARRAY[0..5] OF REAL;
		LongAxisAccVel : {REDUND_UNREPLICABLE} ARRAY[0..1] OF REAL;
		ShortAxisVel : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		PMC_6DMotionVelocity1 : {REDUND_UNREPLICABLE} PMC_6DMotionVelocity;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example03_groups (*2x1 flyways w/ 2 xbots - async,async velocity, create group,block&release group buffer, bond&unbond group*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PosX_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PosY_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		xbotID_array32 : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT;
		PMC_CreateXbotGroup1 : {REDUND_UNREPLICABLE} PMC_CreateXbotGroup;
		PMC_BlockXbotGroup1 : {REDUND_UNREPLICABLE} PMC_BlockXbotGroup;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_BlockXbotGroup2 : {REDUND_UNREPLICABLE} PMC_BlockXbotGroup;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_AutoDrivingMotionVelocity1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotionVelocity;
		PMC_BondXbotGroup1 : {REDUND_UNREPLICABLE} PMC_BondXbotGroup;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion5 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion6 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_BondXbotGroup2 : {REDUND_UNREPLICABLE} PMC_BondXbotGroup;
		PMC_XYMotion7 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_DeleteXbotGroup1 : {REDUND_UNREPLICABLE} PMC_DeleteXbotGroup;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example04_waituntil (*2x1 flyways w/ 2 xbots - waituntil cmdlb,waituntil displacement*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PosX_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PosY_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_WaitUntilCmdLb1 : {REDUND_UNREPLICABLE} PMC_WaitUntilCmdLb;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_WaitUntilDisp1 : {REDUND_UNREPLICABLE} PMC_WaitUntilDisp;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion5 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_WaitUntilDisp2 : {REDUND_UNREPLICABLE} PMC_WaitUntilDisp;
		PMC_XYMotion6 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion7 : {REDUND_UNREPLICABLE} PMC_XYMotion;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example05_pmccontrol (*2x2 flyways w/ 1 xbots sample trajectory set as trajectory 1 (time interval = 10 ms) - trajectory, pause, resume, stop, deactivate, reboot, activate, levitate, arc center*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		xbotID_array12 : {REDUND_UNREPLICABLE} ARRAY[0..11] OF USINT;
		trajID_array12 : {REDUND_UNREPLICABLE} ARRAY[0..11] OF USINT;
		PMC_ActivateTrajectory1 : {REDUND_UNREPLICABLE} PMC_ActivateTrajectory;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_PauseXbots1 : {REDUND_UNREPLICABLE} PMC_PauseXbots;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		PMC_ResumeXbots1 : {REDUND_UNREPLICABLE} PMC_ResumeXbots;
		Delay3 : {REDUND_UNREPLICABLE} Delay;
		PMC_StopXbots1 : {REDUND_UNREPLICABLE} PMC_StopXbots;
		PMC_ArcMotionCenter1 : {REDUND_UNREPLICABLE} PMC_ArcMotionCenter;
		PMC_DeactivateXbots1 : {REDUND_UNREPLICABLE} PMC_DeactivateXbots;
		Delay4 : {REDUND_UNREPLICABLE} Delay;
		PMC_Reboot1 : {REDUND_UNREPLICABLE} PMC_Reboot;
		Delay5 : {REDUND_UNREPLICABLE} Delay;
		PMC_ActivateXbots1 : {REDUND_UNREPLICABLE} PMC_ActivateXbots;
		Delay6 : {REDUND_UNREPLICABLE} Delay;
		PMC_LevitationCtrl1 : {REDUND_UNREPLICABLE} PMC_LevitationCtrl;
		Delay7 : {REDUND_UNREPLICABLE} Delay;
		PMC_LevitationCtrl2 : {REDUND_UNREPLICABLE} PMC_LevitationCtrl;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example06_sync (*4x3 flyways, 4 xbots - get xbot prop, set xbot prop, sync move*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PosX_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PosY_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		xbotID_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		endvel_4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		posx_4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		posy_4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		maxacc_4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		maxvel_4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		PMC_SyncMotion1 : {REDUND_UNREPLICABLE} PMC_SyncMotion;
		PMC_SyncMotion2 : {REDUND_UNREPLICABLE} PMC_SyncMotion;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example07_sun (*4x3 flyways 2 xbots - sun planet*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PosX_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PosY_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		xbotID_array32 : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT;
		PMC_PlanetMotionCtrl1 : {REDUND_UNREPLICABLE} PMC_PlanetMotionCtrl;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_PlanetMotionCtrl2 : {REDUND_UNREPLICABLE} PMC_PlanetMotionCtrl;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example08_bufferstatus (*4x3 flyways 2 xbots - get pmc state, get buffer status*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		pmc_state1 : {REDUND_UNREPLICABLE} USINT;
		nxbots1 : {REDUND_UNREPLICABLE} UINT;
		PMC_GetPmcStatus1 : {REDUND_UNREPLICABLE} PMC_GetPmcStatus;
		buffer_state1 : {REDUND_UNREPLICABLE} USINT;
		ncmds1 : {REDUND_UNREPLICABLE} UINT;
		PMC_GetBufferStatus1 : {REDUND_UNREPLICABLE} PMC_GetBufferStatus;
		PMC_MotionBufferCtrl1 : {REDUND_UNREPLICABLE} PMC_MotionBufferCtrl;
		buffer_state2 : {REDUND_UNREPLICABLE} USINT;
		ncmds2 : {REDUND_UNREPLICABLE} UINT;
		PMC_GetBufferStatus2 : {REDUND_UNREPLICABLE} PMC_GetBufferStatus;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		buffer_state3 : {REDUND_UNREPLICABLE} USINT;
		ncmds3 : {REDUND_UNREPLICABLE} UINT;
		PMC_GetBufferStatus3 : {REDUND_UNREPLICABLE} PMC_GetBufferStatus;
		PMC_MotionBufferCtrl2 : {REDUND_UNREPLICABLE} PMC_MotionBufferCtrl;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example09_groupstatus (*2x1 flyways 2 xbots - delete group, get group status, get macro status*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotID_array32 : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT;
		PMC_CreateXbotGroup1 : {REDUND_UNREPLICABLE} PMC_CreateXbotGroup;
		group_state1 : {REDUND_UNREPLICABLE} USINT;
		nxbots1 : {REDUND_UNREPLICABLE} USINT;
		return_xbotID_array1 : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT;
		PMC_GetGroupStatus1 : {REDUND_UNREPLICABLE} PMC_GetGroupStatus;
		PMC_BondXbotGroup1 : {REDUND_UNREPLICABLE} PMC_BondXbotGroup;
		group_state2 : {REDUND_UNREPLICABLE} USINT;
		nxbots2 : {REDUND_UNREPLICABLE} USINT;
		return_xbotID_array2 : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT;
		PMC_GetGroupStatus2 : {REDUND_UNREPLICABLE} PMC_GetGroupStatus;
		PMC_DeleteXbotGroup1 : {REDUND_UNREPLICABLE} PMC_DeleteXbotGroup;
		group_state3 : {REDUND_UNREPLICABLE} USINT;
		nxbots3 : {REDUND_UNREPLICABLE} USINT;
		return_xbotID_array3 : {REDUND_UNREPLICABLE} ARRAY[0..31] OF USINT;
		PMC_GetGroupStatus3 : {REDUND_UNREPLICABLE} PMC_GetGroupStatus;
		PMC_ClearMacro1 : {REDUND_UNREPLICABLE} PMC_ClearMacro;
		macro_state1 : {REDUND_UNREPLICABLE} USINT;
		nCmds1 : {REDUND_UNREPLICABLE} UINT;
		PMC_GetMacroStatus1 : {REDUND_UNREPLICABLE} PMC_GetMacroStatus;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_SaveMacro1 : {REDUND_UNREPLICABLE} PMC_SaveMacro;
		macro_state2 : {REDUND_UNREPLICABLE} USINT;
		nCmds2 : {REDUND_UNREPLICABLE} UINT;
		PMC_GetMacroStatus2 : {REDUND_UNREPLICABLE} PMC_GetMacroStatus;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example10_waituntiltime (*4x3 flyways 1 xbots - get xbot status, wait until delay*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		posX : {REDUND_UNREPLICABLE} REAL;
		posY : {REDUND_UNREPLICABLE} REAL;
		posZ : {REDUND_UNREPLICABLE} REAL;
		posRx : {REDUND_UNREPLICABLE} REAL;
		posRy : {REDUND_UNREPLICABLE} REAL;
		posRz : {REDUND_UNREPLICABLE} REAL;
		xbot_state : {REDUND_UNREPLICABLE} USINT;
		cmdlb : {REDUND_UNREPLICABLE} UINT;
		PMC_GetXbotStatus1 : {REDUND_UNREPLICABLE} PMC_GetXbotStatus;
		PMC_MotionBufferCtrl1 : {REDUND_UNREPLICABLE} PMC_MotionBufferCtrl;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_WaitUntilTimeDelay1 : {REDUND_UNREPLICABLE} PMC_WaitUntilTimeDelay;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_WaitUntilTimeDelay2 : {REDUND_UNREPLICABLE} PMC_WaitUntilTimeDelay;
		PMC_MotionBufferCtrl2 : {REDUND_UNREPLICABLE} PMC_MotionBufferCtrl;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example11_readxbotposition (*>= 1 xbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		posX : {REDUND_UNREPLICABLE} REAL;
		posY : {REDUND_UNREPLICABLE} REAL;
		posZ : {REDUND_UNREPLICABLE} REAL;
		posRx : {REDUND_UNREPLICABLE} REAL;
		posRy : {REDUND_UNREPLICABLE} REAL;
		posRz : {REDUND_UNREPLICABLE} REAL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadXbotPos1 : {REDUND_UNREPLICABLE} PMC_ReadXbotPos;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example12_DImacro (*4x3 flyways 1 xbot - send digital signal to PMC, macro trigger from DI*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ClearMacro1 : {REDUND_UNREPLICABLE} PMC_ClearMacro;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_SaveMacro1 : {REDUND_UNREPLICABLE} PMC_SaveMacro;
		DI_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		macro_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		xbotID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		PMC_ConfigDI2RunMacro1 : {REDUND_UNREPLICABLE} PMC_ConfigDI2RunMacro;
		PMC_SendDigitalSignalToPMC1 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC2 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example13_waituntilDI (*4x3 flyways 1 xbot - waituntil DI, config DI as trigger*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		DI_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		PMC_ConfigDI2Trigger1 : {REDUND_UNREPLICABLE} PMC_ConfigDI2Trigger;
		PMC_WaitUntilFBDI1 : {REDUND_UNREPLICABLE} PMC_WaitUntilFBDI;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC1 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC2 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example14_DOcmdlb (*4x3 flyways 1 xbot - DO set on cmdlb, DI as reset, read DO from PMC*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		DoID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		xbotID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		cmdlabel_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF UINT;
		type_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		PMC_ConfigDO2CmdLb1 : {REDUND_UNREPLICABLE} PMC_ConfigDO2CmdLb;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		first_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC1 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
		DI_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		Rst_DO_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		PMC_ConfigDI2Reset1 : {REDUND_UNREPLICABLE} PMC_ConfigDI2Reset;
		PMC_SendDigitalSignalToPMC1 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC2 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		second_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC2 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example15_DOdisplacement (*4x3 flyways 1 xbot - DO set on displacement*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		DoID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		xbotID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		type_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		mode_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		threshold_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL;
		xfactor_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL;
		yfactor_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL;
		PMC_ConfigDO2Disp1 : {REDUND_UNREPLICABLE} PMC_ConfigDO2Disp;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		first_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC1 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
		DI_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		Rst_DO_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		PMC_ConfigDI2Reset1 : {REDUND_UNREPLICABLE} PMC_ConfigDI2Reset;
		PMC_SendDigitalSignalToPMC1 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC2 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		second_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC2 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example16_DOmotion (*4x3 flyways 1 xbot - DO set on motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		DoID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		xbotID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		type_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		PMC_ConfigDO2Motion1 : {REDUND_UNREPLICABLE} PMC_ConfigDO2Motion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		first_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC1 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
		DI_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		Rst_DO_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		PMC_ConfigDI2Reset1 : {REDUND_UNREPLICABLE} PMC_ConfigDI2Reset;
		PMC_SendDigitalSignalToPMC1 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC2 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		second_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC2 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example17_cam (*4x3 flyways 2 xbot sample cam set as cam 128 (position interval = 1 mm) - cam motion*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PosX_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PosY_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		slave_axis_array7 : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT;
		cam_ID_array7 : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT;
		master_xbot_ID_array7 : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT;
		master_axis_array7 : {REDUND_UNREPLICABLE} ARRAY[0..6] OF USINT;
		PMC_CamModeCtrl1 : {REDUND_UNREPLICABLE} PMC_CamModeCtrl;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_CamModeCtrl2 : {REDUND_UNREPLICABLE} PMC_CamModeCtrl;
		PMC_AutoDrivingMotion2 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		SlaveAID_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		camID_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		MasterXID_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		MasterAID_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		MasterAOffset_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		SlaveAOffset_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		MasterAScaling_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		SlaveAScaling_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		CamMode_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		MasterOffsetMode_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF USINT;
		PMC_CamModeCtrlAdvanced1 : {REDUND_UNREPLICABLE} PMC_CamModeCtrlAdvanced;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_CamModeCtrlAdvanced2 : {REDUND_UNREPLICABLE} PMC_CamModeCtrlAdvanced;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example18_jogging (*4x3 flyways 1 xbot - jogging, jogging short axis*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_JogVelocity1 : {REDUND_UNREPLICABLE} PMC_JogVelocity;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_JogVelocity2 : {REDUND_UNREPLICABLE} PMC_JogVelocity;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		PMC_JogVelocity3 : {REDUND_UNREPLICABLE} PMC_JogVelocity;
		Delay3 : {REDUND_UNREPLICABLE} Delay;
		PMC_JogVelocity4 : {REDUND_UNREPLICABLE} PMC_JogVelocity;
		Delay4 : Delay;
		PMC_JogShortAxis1 : PMC_JogShortAxis;
		Delay5 : Delay;
		PMC_JogshortAxis2 : PMC_JogShortAxis;
		Delay6 : Delay;
		PMC_JogShortAxis3 : PMC_JogShortAxis;
		Delay7 : Delay;
		PMC_JogshortAxis4 : PMC_JogShortAxis;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK Example19_force (*1 flyway (actual physical) w/ 1 xbots - force mode ctrl,read payload,read flyway temps*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ForceModeCtrl1 : PMC_ForceModeCtrl;
		payload : REAL;
		PMC_WeighXbot1 : PMC_WeighXbotAsync;
		power : REAL;
		cpuTemp : REAL;
		PATemp : REAL;
		MTemp : REAL;
		PMC_GetFlywayStatus1 : PMC_GetFlywayStatus;
		Delay1 : Delay;
		PMC_ForceModeCtrl2 : PMC_ForceModeCtrl;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example20_DOforce (*1 flyway (actual physical) w/ 1 xbots - DO set on force*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		DoID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		xbotID_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		type_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		axis_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF USINT;
		threshold_array5 : {REDUND_UNREPLICABLE} ARRAY[0..4] OF REAL;
		PMC_ConfigDO2Force1 : {REDUND_UNREPLICABLE} PMC_ConfigDO2Force;
		first_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC1 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
		DI_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		Rst_DO_ID_array22 : {REDUND_UNREPLICABLE} ARRAY[0..21] OF USINT;
		PMC_ConfigDI2Reset1 : {REDUND_UNREPLICABLE} PMC_ConfigDI2Reset;
		PMC_SendDigitalSignalToPMC1 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_SendDigitalSignalToPMC2 : {REDUND_UNREPLICABLE} PMC_SendDigitalSignalToPMC;
		Delay2 : {REDUND_UNREPLICABLE} Delay;
		second_read : {REDUND_UNREPLICABLE} BOOL;
		PMC_ReadDigitalSignalFromPMC2 : {REDUND_UNREPLICABLE} PMC_ReadDigitalSignalFromPMC;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example21_startupPMS (*any amount of xbots *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_StartUpPlanarMotorSystem1 : {REDUND_UNREPLICABLE} PMC_StartUpPlanarMotorSystem;
		xbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..99] OF USINT;
		numXbots : {REDUND_UNREPLICABLE} USINT;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example22_stream (*5x2 flyways 9 xbots - StreamModeCtrl,WriteStream,ConfigFBStream,read feedback*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_StopXbots1 : {REDUND_UNREPLICABLE} PMC_StopXbots;
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		posx_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		posy_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		StmID_array8 : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT;
		XbotID_array8 : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT;
		FBmode_array8 : {REDUND_UNREPLICABLE} ARRAY[0..7] OF USINT;
		PMC_ConfigFBStream1 : {REDUND_UNREPLICABLE} PMC_ConfigFBStream;
		xbotID_array9 : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT;
		stmID_array9 : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT;
		stmAxis_array9 : {REDUND_UNREPLICABLE} ARRAY[0..8] OF USINT;
		PMC_StreamModeCtrl1 : {REDUND_UNREPLICABLE} PMC_StreamModeCtrl;
		read_y_pos : {REDUND_UNREPLICABLE} REAL;
		PMC_ReadStreamFeedback1 : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedback;
		PMC_WriteStream1 : {REDUND_UNREPLICABLE} PMC_WriteStream;
		PMC_StreamModeCtrl2 : {REDUND_UNREPLICABLE} PMC_StreamModeCtrl;
		xindex : {REDUND_UNREPLICABLE} SINT;
		y_pos : {REDUND_UNREPLICABLE} REAL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example23_holdfor (*4x3 flyways 4 xbots - HoldForPMCState, HoldForXbot(s)Idle, HoldForXbot(s)State*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_Reboot1 : {REDUND_UNREPLICABLE} PMC_Reboot;
		PMC_HoldForPMCState1 : {REDUND_UNREPLICABLE} PMC_HoldForPMCState;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_ActivateXbots1 : {REDUND_UNREPLICABLE} PMC_ActivateXbots;
		PMC_HoldForXbotIdle1 : {REDUND_UNREPLICABLE} PMC_HoldForXbotIdle;
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		posX_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		posY_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotionVelocity1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotionVelocity;
		PMC_HoldForXbotState1 : {REDUND_UNREPLICABLE} PMC_HoldForXbotState;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_HoldForXbotsIdle1 : {REDUND_UNREPLICABLE} PMC_HoldForXbotsIdle;
		PMC_XYMotion5 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_LevitationCtrl1 : {REDUND_UNREPLICABLE} PMC_LevitationCtrl;
		state_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PMC_HoldForXbotsState1 : {REDUND_UNREPLICABLE} PMC_HoldForXbotsState;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example24a_autoloading_sending (*1 flyway 1 xbot (actual physical) - autoloading delete,create,activate,holdforzoneready,unload*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_AutoLoadingZone_Delete1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_Delete;
		xbotID_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		posx_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		posy_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		PMC_AutoLoadingZone_Create1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_Create;
		PMC_AutoLoadingZone_Activate1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_Activate;
		PMC_AutoLoadingZon_HolZoneReady1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZon_HoldZoneReady;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_AutoLoadingZone_UnloadXbot1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_UnloadXbot;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example24b_autoloading_receiving (*1 flyway 1 xbot (actual physical) - autoloading delete,create,activate,holdforzoneready,loadingzoneclear *) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_AutoLoadingZone_Delete1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_Delete;
		PMC_AutoLoadingZone_Create1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_Create;
		PMC_AutoLoadingZone_Activate1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZone_Activate;
		PMC_AutoLoadingZon_HolZoneReady1 : {REDUND_UNREPLICABLE} PMC_AutoLoadingZon_HoldZoneReady;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_AutoLoadZone_LoadZoneClear1 : {REDUND_UNREPLICABLE} PMC_AutoLoadZone_LoadZoneClear;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example25_stereotypes (*4x3 flyways 1 xbot - MoverStereotype Define, Assign, ReadDef*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		cg_array3 : {REDUND_UNREPLICABLE} ARRAY[0..2] OF REAL;
		payloadsize_array4 : {REDUND_UNREPLICABLE} ARRAY[0..3] OF REAL;
		PMC_MoverStereotype_Define1 : {REDUND_UNREPLICABLE} PMC_MoverStereotype_Define;
		PMC_MoverStereotype_ReadDef1 : {REDUND_UNREPLICABLE} PMC_MoverStereotype_ReadDef;
		PMC_MoverStereotype_Assign1 : {REDUND_UNREPLICABLE} PMC_MoverStereotype_Assign;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_MoverStereotype_Define2 : {REDUND_UNREPLICABLE} PMC_MoverStereotype_Define;
		PMC_MoverStereotype_ReadDef2 : {REDUND_UNREPLICABLE} PMC_MoverStereotype_ReadDef;
		PMC_MoverStereotype_Assign2 : {REDUND_UNREPLICABLE} PMC_MoverStereotype_Assign;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
	END_VAR
END_FUNCTION_BLOCK

FUNCTION_BLOCK Example26_serialnumbers (*at least 2 flyways (physical) - GetFlywaySerialNum, PMC_GetPMCSerialNum, PMC_GetPMCVersion*)
	VAR_INPUT
		Execute : BOOL;
	END_VAR
	VAR_OUTPUT
		Done : BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;
	END_VAR
	VAR
		PMC_GetPMCVersion1 : PMC_GetPMCVersion;
		PMC_GetPMCSerialNum1 : PMC_GetPMCSerialNum;
		PMC_GetFlywaySerialNum1 : PMC_GetFlywaySerialNum;
		PMC_GetFlywaySerialNum2 : PMC_GetFlywaySerialNum;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example27_levitatelandspeed (*2x1 flyways 1 xbot - LevitationLandw/Speed*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		levland_times : {REDUND_UNREPLICABLE} ARRAY[0..9] OF DINT;
		time_count : {REDUND_UNREPLICABLE} DINT;
		PMC_LevitationCtrlSpeed1 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed2 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed3 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed4 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed5 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed6 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed7 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed8 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed9 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
		PMC_LevitationCtrlSpeed10 : {REDUND_UNREPLICABLE} PMC_LevitationCtrlSpeed;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example28a_zoneunloading (*2x1 flyways 2 xbots (actual physical) - ZoneCtrl*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
		UserFinishedRemovingXbot : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		UserCanRemoveXbot : {REDUND_UNREPLICABLE} BOOL;
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		xbotid_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		posx_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		posy_array78 : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_Zone_ZoneCtrl1 : {REDUND_UNREPLICABLE} PMC_Zone_ZoneCtrl;
		PMC_Zone_ZoneCtrl2 : {REDUND_UNREPLICABLE} PMC_Zone_ZoneCtrl;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example28b_zoneloading (*2x1 flyways 2 xbots (actual physical) - ZoneCtrl, FenceCtrl, GetStatus*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
		UserFinishedAddingXbot : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		UserCanAddXbot : {REDUND_UNREPLICABLE} BOOL;
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_Zone_ZoneCtrl1 : {REDUND_UNREPLICABLE} PMC_Zone_ZoneCtrl;
		PMC_Zone_ZoneCtrl2 : {REDUND_UNREPLICABLE} PMC_Zone_ZoneCtrl;
		PMC_Zone_Fencing1 : {REDUND_UNREPLICABLE} PMC_Zone_Fencing;
		PMC_Zone_GetStatus1 : {REDUND_UNREPLICABLE} PMC_Zone_GetStatus;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK Example29_recoveryaccident (*any number of flyways and xbots (real physical, with at least 1 xbot having suffered a tracking error) - GetAllAccidentXbots, RecoverAccidentXbot*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_ReadNumAccidentXbots1 : PMC_ReadNumAccidentXbots;
		PMC_GetAllAccidentXbots1 : {REDUND_UNREPLICABLE} PMC_GetAllAccidentXbots;
		PMC_RecoverAccidentXbot1 : {REDUND_UNREPLICABLE} PMC_RecoverAccidentXbot;
		num_accident : USINT;
		recovering_xbots : BOOL := FALSE;
		xbot_index : {REDUND_UNREPLICABLE} INT := 0;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example30_incoming (*2x1 flyways 1 xbot (actual physical) with border 1 on the bottom edge of the 2 flyways - GetBorderStatus, ReadNumIncomingXbots, GetIncomingXbots*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_GetBorderStatus1 : {REDUND_UNREPLICABLE} PMC_GetBorderStatus;
		PMC_ReadNumIncomingXbots1 : {REDUND_UNREPLICABLE} PMC_ReadNumIncomingXbots;
		num_incoming : {REDUND_UNREPLICABLE} USINT;
		processing_new_xbot : {REDUND_UNREPLICABLE} BOOL;
		PMC_GetIncomingXbots1 : {REDUND_UNREPLICABLE} PMC_GetIncomingXbots;
		nXbots : {REDUND_UNREPLICABLE} USINT;
		XbotIDS : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT;
		BorderIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example31_extendedfeedback (*any flyway configuration 50 xbots - PMC_ConfigFBStreamExtended, PMC_ReadStreamFeedbackExtended, PMC_ReadXbotSpeed*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..149] OF USINT;
		PMC_ConfigFBStreamExtended1 : {REDUND_UNREPLICABLE} PMC_ConfigFBStreamExtended;
		PMC_ReadXbot31X : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot31Y : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot31Z : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot31Speed : PMC_ReadXbotSpeed;
		PMC_ReadXbot42X : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot42Y : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot42Z : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot42Speed : PMC_ReadXbotSpeed;
		PMC_ReadXbot50X : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot50Y : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot50Z : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbot50Speed : PMC_ReadXbotSpeed;
		PMC_ReadXbotAnyX : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbotAnyY : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbotAnyZ : {REDUND_UNREPLICABLE} PMC_ReadStreamFeedbackExtended;
		PMC_ReadXbotAnySpeed : PMC_ReadXbotSpeed;
		X31 : {REDUND_UNREPLICABLE} REAL;
		Y31 : {REDUND_UNREPLICABLE} REAL;
		Z31 : {REDUND_UNREPLICABLE} REAL;
		X42 : {REDUND_UNREPLICABLE} REAL;
		Y42 : {REDUND_UNREPLICABLE} REAL;
		Z42 : {REDUND_UNREPLICABLE} REAL;
		X50 : {REDUND_UNREPLICABLE} REAL;
		Y50 : {REDUND_UNREPLICABLE} REAL;
		Z50 : {REDUND_UNREPLICABLE} REAL;
		AnyXID : {REDUND_UNREPLICABLE} USINT := 1;
		XAny : {REDUND_UNREPLICABLE} REAL;
		YAny : {REDUND_UNREPLICABLE} REAL;
		ZAny : {REDUND_UNREPLICABLE} REAL;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} FUNCTION_BLOCK Example32_zonefencing (*2x1 flyways 1 xbots - ZoneFencing,DefineZone,ZoneGetStatus*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_Zone_DefineZone1 : {REDUND_UNREPLICABLE} PMC_Zone_DefineZone;
		PMC_Zone_Fencing1 : {REDUND_UNREPLICABLE} PMC_Zone_Fencing;
		PMC_Zone_GetStatus1 : {REDUND_UNREPLICABLE} PMC_Zone_GetStatus;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		Delay1 : {REDUND_UNREPLICABLE} Delay;
		PMC_Zone_OverrideZone1 : PMC_Zone_OverrideZone;
		PMC_Zone_Fencing2 : {REDUND_UNREPLICABLE} PMC_Zone_Fencing;
		PMC_Zone_OverrideZone2 : PMC_Zone_OverrideZone;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example33_StarWheel (*3x3 flyways 6 xbots - star wheel module demo CreateStar, DeleteStar, GetStarStatus, SendXbotToStar, StarExitClear*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		Setup : {REDUND_UNREPLICABLE} Example33_StarWheelSetup;
		wheel_angle : {REDUND_UNREPLICABLE} REAL;
		write_angle : {REDUND_UNREPLICABLE} PMC_WriteStream;
		rotation_speed : {REDUND_UNREPLICABLE} REAL := 1.0;
		next_xbot : {REDUND_UNREPLICABLE} USINT := 1;
		check_wheel_status : {REDUND_UNREPLICABLE} PMC_Star_GetStarStatus;
		execute_return : {REDUND_UNREPLICABLE} BOOL;
		return_xbot : {REDUND_UNREPLICABLE} PMC_RunMacro;
		clear_exit : {REDUND_UNREPLICABLE} PMC_Star_StarExitClear;
		read_xbot_state : {REDUND_UNREPLICABLE} PMC_ReadXbotState;
		next_xbot_ready : {REDUND_UNREPLICABLE} BOOL;
		send_xbot_to_wheel : {REDUND_UNREPLICABLE} PMC_Star_SendXbotToStar;
	END_VAR
	VAR CONSTANT
		PI : REAL := 3.141593;
		cycle_time : REAL := 0.001;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example33_StarWheelSetup (*Initial setup for Example33_StarWheel*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (*Tracks state of the entire PMC system*)
	END_VAR
	VAR
		PMC_StopXbots1 : {REDUND_UNREPLICABLE} PMC_StopXbots;
		PMC_DeleteStarWheel1 : {REDUND_UNREPLICABLE} PMC_Star_DeleteStar;
		PMC_ClearMacro1 : {REDUND_UNREPLICABLE} PMC_ClearMacro;
		PMC_XYMotion1 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ArcMotionTarget1 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion2 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_ArcMotionTarget2 : {REDUND_UNREPLICABLE} PMC_ArcMotionTarget;
		PMC_XYMotion3 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		PMC_SaveMacro1 : {REDUND_UNREPLICABLE} PMC_SaveMacro;
		PMC_AutoDrivingMotion1 : {REDUND_UNREPLICABLE} PMC_AutoDrivingMotion;
		XbotIDs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF USINT;
		PosXs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PosYs : {REDUND_UNREPLICABLE} ARRAY[0..77] OF REAL;
		PMC_XYMotion4 : {REDUND_UNREPLICABLE} PMC_XYMotion;
		xbot_id : {REDUND_UNREPLICABLE} USINT := 1;
		PMC_CreateStarWheel1 : {REDUND_UNREPLICABLE} PMC_Star_CreateStar;
		Vials : {REDUND_UNREPLICABLE} ARRAY[0..99] OF REAL;
		PMC_StreamModeCtrl1 : {REDUND_UNREPLICABLE} PMC_StreamModeCtrl;
		Disc_Radius : {REDUND_UNREPLICABLE} REAL := 0.3;
		Disc_X : {REDUND_UNREPLICABLE} REAL := 0.36;
		Disc_Y : {REDUND_UNREPLICABLE} REAL := 0.36;
		Clearance_Space : {REDUND_UNREPLICABLE} REAL := 0.15;
	END_VAR
	VAR CONSTANT
		PI : REAL := 3.141593;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example34_RotaryMotion (*1x1 flyways 1 xbots - SingleAxisMotion,RotaryMotion,RotaryMotionSpin*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_OUTPUT
		Done : {REDUND_UNREPLICABLE} BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType; (* the planar motor controller to use*)
	END_VAR
	VAR
		PMC_SingleAxisMotion0 : {REDUND_UNREPLICABLE} PMC_SingleAxisMotion;
		PMC_SingleAxisMotion1 : {REDUND_UNREPLICABLE} PMC_SingleAxisMotion;
		PMC_SingleAxisMotion2 : {REDUND_UNREPLICABLE} PMC_SingleAxisMotion;
		PMC_RotaryMotion0 : {REDUND_UNREPLICABLE} PMC_RotaryMotion;
		PMC_RotaryMotionSpin0 : {REDUND_UNREPLICABLE} PMC_RotaryMotionSpin;
		PI : {REDUND_UNREPLICABLE} REAL := 3.14159265;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example35_Sectors (*2x1 flyways 1 xbot (actual physical, left flyway set as master, right flyway set as sector 1) - PMC_Sector_Activate, PMC_Sector_Deactivate, PMC_Sector_Recover, PMC_Sector_GetStatus*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;
		UserReconnectFinished : BOOL;
	END_VAR
	VAR_OUTPUT
		UserCanDisconnectFlyway : BOOL;
		Done : BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;
	END_VAR
	VAR
		PMC_XYMotion1 : PMC_XYMotion;
		PMC_Sector_Deactivate1 : PMC_Sector_Deactivate;
		PMC_Sector_GetStatus1 : PMC_Sector_GetStatus; 
		PMC_XYMotion2 : PMC_XYMotion;
		PMC_Sector_Activate1 : PMC_Sector_Activate;
		PMC_Sector_Recover1 : PMC_Sector_Recover;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example36_SetDateAndTime (*any combination of xbots and flyways - SetDateAndTime*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;
	END_VAR
	VAR_OUTPUT
		Done : BOOL;
	END_VAR
	VAR_IN_OUT
		PM_Controller : PMControllerType;
	END_VAR
	VAR
		LocalTime : RTCtime_typ;
		TimeError : UINT;
		PMC_SetDateAndTime1 : PMC_SetDateAndTime;
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK PseudoRandom (*generates pseudo random 32 bit unsigned integers (algorithm is linear congruential generator)*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;	(*generate new random number on the rising edge of this signal*)
		Seed : UDINT;	(*seed value, locked in on first rising edge of execute*)
	END_VAR
	VAR_OUTPUT
		RandomNumber : UDINT;	(*output pseudo random 32 bit unsigned integer between 0 and 2^32-1*)
	END_VAR
	VAR
		first_use : BOOL := TRUE;
		previous_execute : BOOL := FALSE;
	END_VAR
	VAR CONSTANT
		m : UDINT := 4294967295;
		a : UDINT := 1664525;
		c : UDINT := 1013904223; 
	END_VAR
END_FUNCTION_BLOCK

{REDUND_ERROR} {REDUND_UNREPLICABLE} FUNCTION_BLOCK Example37_ApplicationDesigner (*5x5 flyways - up to 10 xbots with the example application design loaded on the PMC as design 1*) (*$GROUP=User,$CAT=User,$GROUPICON=User.png,$CATICON=User.png*)
	VAR_INPUT
		Execute : BOOL;
	END_VAR
	VAR_OUTPUT
	END_VAR
	VAR_IN_OUT
		PMC : PMControllerType;
	END_VAR
	VAR
		Reboot : PMC_Reboot;
		ActivatePMC : PMC_ActivateXbots;
	
		ReadXbotIDs : PMC_ReadXbotIDs;
		i : INT;
		Home : PMC_AutoDrivingMotion;
		XbotIndex : USINT;
		SendToStart : PMC_App_SendXbotToStation;
	
		HoldForXbot_Station1Bay1 : PMC_App_HoldForBay;
		SelectNextBay_Station1Bay1 : PseudoRandom;
		SendToNextBay_Station1Bay1 : PMC_App_SendXbotToStation;
	
		HoldForXbot_Station1Bay2 : PMC_App_HoldForBay;
		SelectNextBay_Station1Bay2 : PseudoRandom;
		SendToNextBay_Station1Bay2 : PMC_App_SendXbotToStation;
	
		HoldForXbot_Station2Bay1 : PMC_App_HoldForBay;
		SelectNextBay_Station2Bay1 : PseudoRandom;
		SendToNextBay_Station2Bay1 : PMC_App_SendXbotToStation;
	
		HoldForXbot_Station2Bay2 : PMC_App_HoldForBay;
		SelectNextBay_Station2Bay2 : PseudoRandom;
		SendToNextBay_Station2Bay2 : PMC_App_SendXbotToStation;
	END_VAR
END_FUNCTION_BLOCK
